from docplex.cp.model import logical_and, logical_or

from typing import Tuple



'''Useful functions for z3 equations'''

def rOr(equations:list, pos:int = 0):
    '''Crea un'unica equazione mettendo in Or tra loro tutte le equazione passate.\n
    Args:
        equations (list): lista di equazioni
        pos (int): posizione corrente. Alla prima chiamata deve valere 0.\n
    Returns:
        equazione: equazione data dall'or di tutte le equazioni
    '''
    if pos+1 == len(equations):
        return equations[pos]
    return logical_or(rOr(equations, pos+1), equations[pos])
    
def rAnd(equations:list, pos:int = 0):
    '''Crea un'unica equazione mettendo in And tra loro tutte le equazione passate.\n
    Args:
        equations (list): lista di equazioni
        pos (int): posizione corrente. Alla prima chiamata deve valere 0.\n
    Returns:
        equazione: equazione data dall'and di tutte le equazioni
    '''
    if pos+1 == len(equations):
        return equations[pos]
    return logical_and(rAnd(equations, pos+1), equations[pos])


def isSlotsOverlapped(s1:Tuple[Tuple[int,int],int], s2:Tuple[Tuple[int,int]]) -> bool:
    '''Check overlaps about 2 slots'''
    # day
    if s1[0][0] != s2[0][0]:
        return False
    if s1[0][1] + s1[1] > s2[0][1] and s1[0][1] < s2[0][1]:
        # s1 parte prima di s2 e NON finisce prima che s2 comincia
        return True
    if s2[0][1] + s2[1] > s1[0][1] and s2[0][1] < s1[0][1]:
        # s2 parte prima di s1 e NON finisce perima che s1 cominci
        return True
    if s2[0][1] == s1[0][1]:
        # contemporanee
        return True 
    return False